<?php
	class st_hybrid_about extends WP_Widget{
	
		function st_hybrid_about() 
		{
			parent::WP_Widget(false, $name = 'Hybrid > About');
		}
		
		function widget($args, $instance)
		{
			extract( $args );
			$title = apply_filters('widget_title', $instance['title']);		
			$ttitle = $instance['ttitle'];
			$category = $instance['category'];
			$text = $instance['text'];
			if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '<div class="span3">';// Display some text
			}
			  ?>
			
					 	<h3><?php echo $title ; ?></h3>
						 <div class="widget" id="simple-about">
						 	<h4><?php echo $ttitle; ?></h4>
						 	<p class="post-categoty"><?php echo $category; ?></p>
						 	<p class="desc">
						 		<?php echo $text; ?>
						 	</p>
						 </div>		
			 
			  			
				<?php
				if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '</div>';
					}
		}
		
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			$instance['ttitle'] = strip_tags($new_instance['ttitle']);
			$instance['category'] = strip_tags($new_instance['category']);
			$instance['text'] = strip_tags($new_instance['text']);
			return $instance;
		}
		
		function form($instance)
		{
			$title = isset($instance['title']) ? esc_attr($instance['title']) : "";	
			$ttitle = isset($instance['title']) ? esc_attr($instance['ttitle']) : "";	
			$category = isset($instance['title']) ? esc_attr($instance['category']) : "";				
			$text = isset($instance['text']) ? esc_attr($instance['text']) : "";					
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"hybrid_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('ttitle'); ?>"><?php _e('Title',"hybrid_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('ttitle'); ?>" name="<?php echo $this->get_field_name('ttitle'); ?>" type="text" value="<?php echo $ttitle; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('category'); ?>"><?php _e('Category',"hybrid_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('category'); ?>" name="<?php echo $this->get_field_name('category'); ?>" type="text" value="<?php echo $category; ?>" />
			</p>
			<p>			
				<label for="<?php echo $this->get_field_id('text'); ?>"><?php _e('Text',"hybrid_lang"); ?></label>
			</p>				
				<textarea rows="16" col="12" class="widefat"  id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" type="text" value="<?php echo $text; ?>" ><?php echo $text; ?></textarea>
			
			<?php
		}
	}
	
	function st_hybrid_widgets_about() {			
		register_widget('st_hybrid_about');			
	}
	add_action('widgets_init', 'st_hybrid_widgets_about');
?>